<?php
if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly
}
?>
<div class="wrap">
	<h1><?php _e('Getting Started with Real3D Flipbook', 'r3dfb'); ?></h1>

	<p><?php _e('Welcome to Real3D Flipbook! Transform your content into engaging flipbooks that captivate your audience. Whether you\'re showcasing portfolios, magazines, or product catalogs, Real3D Flipbook offers a seamless and interactive experience.', 'r3dfb'); ?></p>

	<?php
	
	?>
	<p><?php _e('Refer to the <a href="https://real3dflipbook.gitbook.io/wp-lite" target="_blank">Online Documentation</a> for detailed instructions and tips on using Real3D Flipbook.', 'r3dfb'); ?></p>
	<p><?php _e('Need help or want to report a bug? Visit the <a href="https://wordpress.org/support/plugin/real3d-flipbook-lite/" target="_blank">Support Forum</a> to get assistance or share your feedback with the community.', 'r3dfb'); ?></p>
	<?php
	
	?>
	<?php
	?>

	<p><?php _e('Ready to start? Create your first flipbook now:', 'r3dfb'); ?>
    	<a href="<?php echo admin_url('post-new.php?post_type=r3d'); ?>" class="button button-primary"><?php _e('Add New Flipbook', 'r3dfb'); ?></a>
	</p>

	<?php
	
	?>
	<p><?php _e('Watch the tutorial video below for a quick overview of Real3D Flipbook\'s features:', 'r3dfb'); ?></p>
	<iframe width="560" height="315" src="https://www.youtube.com/embed/1ljFRYr0Kh8" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
	<?php
	
	?>
</div>
